package gov.va.med.mhv.sm.admin.enums;

public enum CountsSubCategoryTypeEnum {
	
	SUM (0, "Sum"),
	AVERAGE (1, "Average"),
	MINIMUM (2, "Minimum"),
	MAXIMUM (3, "Maximum");
	
	private int id;
	private String description;
	
	private CountsSubCategoryTypeEnum(int id, String description){
		this.id = id;
		this.description = description;
	}
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	
	public static CountsSubCategoryTypeEnum valueOf(int value){
		for(CountsSubCategoryTypeEnum f : CountsSubCategoryTypeEnum.values()){
			if(f.getId() == value)
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no CountsSubCategoryTypeEnum type found for " + value);
	}
	
}
